<?php
class Employees extends Controller {
    private $employeeModel;

    public function __construct() {
        if (session_status() == PHP_SESSION_NONE) session_start();
        if (!isset($_SESSION['user'])) {
            // protect: redirect to login
            header("Location: " . APP_PATH . "auth");
            exit;
        }

        $this->employeeModel = $this->logic("Employee_model");
    }

    // show employees UI (the full HTML you provided)
    public function index() {
        // the view you provided is a full HTML file (contains <html> etc).
        // We just include it as provided.
        $this->display("employees/index");
    }

    // optional API endpoints if you want to persist (not required by your UI)
    public function list() {
        header('Content-Type: application/json');
        echo json_encode($this->employeeModel->getAllEmployees());
    }

    public function add() {
        // handle add (if you change UI to post to /employees/add)
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->employeeModel->insertEmployee($_POST, $_FILES ?? []);
            header("Location: " . APP_PATH . "employees");
            exit;
        }
    }

    public function update() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->employeeModel->updateEmployee($_POST, $_FILES ?? []);
            header("Location: " . APP_PATH . "employees");
            exit;
        }
    }

    public function delete($id) {
        $this->employeeModel->deleteEmployee($id);
        header("Location: " . APP_PATH . "employees");
        exit;
    }
}
?>
