<?php
// employees/index.php modern corporate (expects $data)
?>
<div class="container-fluid">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4>Employees</h4>
    <div>
      <a class="btn btn-outline-secondary me-2" href="<?= APP_PATH ?>employees">Refresh</a>
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalAdd">Add Employee</button>
    </div>
  </div>

  <div class="card mb-3">
    <div class="card-body">
      <div class="table-responsive">
        <table id="employeesTable" class="table table-hover table-striped align-middle">
          <thead>
            <tr>
              <th>#</th>
              <th>Avatar</th>
              <th>Name</th>
              <th>Position</th>
              <th>Email</th>
              <th>Join Date</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php $i = (($data['page'] ?? 1)-1)*($data['perPage'] ?? 10) + 1; foreach($data['employees'] as $emp): ?>
            <tr>
              <td><?= $i++; ?></td>
              <td>
                <?php if(!empty($emp['photo'])): ?>
                  <img src="<?= APP_PATH ?>img/employees/<?= $emp['photo'] ?>" alt="" class="avatar">
                <?php else: ?>
                  <div class="avatar" style="background:#e9ecef;display:inline-block;"></div>
                <?php endif; ?>
              </td>
              <td><?= htmlspecialchars($emp['name']) ?></td>
              <td><?= htmlspecialchars($emp['position']) ?></td>
              <td><?= htmlspecialchars($emp['email']) ?></td>
              <td><?= htmlspecialchars($emp['join_date']) ?></td>
              <td>
                <button class="btn btn-sm btn-outline-warning" data-bs-toggle="modal" data-bs-target="#modalEdit"
                  data-id="<?= $emp['id'] ?>" data-name="<?= htmlspecialchars($emp['name'], ENT_QUOTES) ?>"
                  data-position="<?= htmlspecialchars($emp['position'], ENT_QUOTES) ?>" data-email="<?= htmlspecialchars($emp['email'], ENT_QUOTES) ?>"
                  data-join="<?= htmlspecialchars($emp['join_date'], ENT_QUOTES) ?>" >Edit</button>

                <a class="btn btn-sm btn-danger" href="<?= APP_PATH ?>employees/delete/<?= $emp['id'] ?>" onclick="return confirm('Delete?')">Delete</a>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <!-- pagination -->
      <?php if(!empty($data['totalPages']) && $data['totalPages']>1): ?>
      <nav class="mt-3">
        <ul class="pagination">
          <?php for($p=1;$p<=$data['totalPages'];$p++): ?>
            <li class="page-item <?= ($p==($data['page']??1))?'active':'' ?>">
              <a class="page-link" href="<?= APP_PATH ?>employees?page=<?= $p ?>"><?= $p ?></a>
            </li>
          <?php endfor; ?>
        </ul>
      </nav>
      <?php endif; ?>

    </div>
  </div>
</div>

<!-- Add/Edit modals: keep forms same as previous version, omitted here for brevity -->
<script>
document.addEventListener('DOMContentLoaded', function(){
  window._employeesTable = $('#employeesTable').DataTable({
    pageLength: <?= intval($data['perPage'] ?? 10) ?>,
    lengthChange: false,
    ordering: true
  });

  // populate edit modal (if used)
  var editModal = document.getElementById('modalEdit');
  if(editModal){
    editModal.addEventListener('show.bs.modal', function(e){
      var btn = e.relatedTarget;
      document.querySelector('[name="id"]').value = btn.getAttribute('data-id');
      document.querySelector('[name="name"]').value = btn.getAttribute('data-name');
      document.querySelector('[name="position"]').value = btn.getAttribute('data-position');
      document.querySelector('[name="email"]').value = btn.getAttribute('data-email');
      document.querySelector('[name="join_date"]').value = btn.getAttribute('data-join');
    });
  }
});
</script>
