<?php
// dashboard/index.php
// expects $data['title'], $data['total'] etc.
?>
<div class="container-fluid">
  <div class="row mb-3">
    <div class="col-md-3">
      <div class="card p-3">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center">
            <div>
              <h6 class="card-title">Total Employees</h6>
              <h3><?= intval($data['total'] ?? 0) ?></h3>
            </div>
            <div><i class="bi bi-people" style="font-size:28px;color:var(--brand)"></i></div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-9">
      <div class="card p-3">
        <div class="card-body">
          <canvas id="employeesChart" height="80"></canvas>
        </div>
      </div>
    </div>
  </div>

  <!-- recent table (reuse employees table) -->
  <div class="row">
    <div class="col-12">
      <?php $this->display("employees/index", $data); ?>
    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function(){
  const ctx = document.getElementById('employeesChart').getContext('2d');
  // sample dataset (you can compute real data in controller)
  const chart = new Chart(ctx, {
    type: 'line',
    data: {
      labels: ['Jan','Feb','Mar','Apr','May','Jun'],
      datasets: [{
        label: 'New employees',
        data: [3,5,2,8,6,4],
        fill: true,
        tension: 0.3,
        backgroundColor: 'rgba(13,110,253,0.12)',
        borderColor: 'rgba(13,110,253,0.9)'
      }]
    },
    options: { responsive:true, plugins:{legend:{display:false}} }
  });
});
</script>
