<?php
class Database {
    private $server_name = HOST_DB;
    private $db_name     = NAME_DB;
    private $user_name   = USER_DB;
    private $password    = PASS_DB;

    private $con;

    public function __construct() {
        $this->con = $this->db_connection(
            $this->server_name,
            $this->user_name,
            $this->password,
            $this->db_name
        );

        if ($this->con == false) {
            echo "Status: connection failed.";
        } else {
            echo "Status: connected successfully.";
        }
    }

    private function db_connection($srvr_nm, $usr_nm, $psswrd, $db_nm) {
        $conn = new mysqli($srvr_nm, $usr_nm, $psswrd, $db_nm);
        if ($conn->connect_error) {
            echo "Connection failed: " . $conn->connect_error;
            return false;
        }
        // set charset
        $conn->set_charset('utf8mb4');
        return $conn;
    }

    public function query($sql) {
        return $this->con->query($sql);
    }

    public function escape($str) {
        return $this->con->real_escape_string($str);
    }

    // expose connection only if needed
    public function getConnection() {
        return $this->con;
    }

    public function db_close() {
        $this->con->close();
    }
}
?>
