<?php
class Login extends Controller {

    private $loginModel;

    public function __construct() {
        $this->loginModel = $this->logic('LoginModel');
    }

    public function index() {
        $this->display('auth/login');
    }

    public function auth() {
        $email = $_POST['email'] ?? '';
        $pass  = $_POST['password'] ?? '';

        $user = $this->loginModel->getUserByEmail($email);

        if (!$user) {
            $_SESSION['error'] = "Email not found!";
            header("Location: /login");
            exit;
        }

        if (!password_verify($pass, $user['password'])) {
            $_SESSION['error'] = "Wrong password!";
            header("Location: /login");
            exit;
        }

        $_SESSION['user'] = $user;
        header("Location: /employees");
    }
}
